/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.certs.RemovableMediaDevice;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class RemovableMediaChoiceBean
extends PanelBean
implements CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTRMCD";
    private static final String TRACE_MASKF = "XCRTRMCF";
    private static final String TRACE_MASKT = "XCRTRMCT";
    private ArrayList devices;
    private Serializable opaqueObject;
    private LocalizableText introLabel;
    private String m_sListBox = "";
    private ValueDescriptor[] m_vdListBox;
    private String m_sIntroLabel;

    public RemovableMediaChoiceBean(LocalizableText introLabel, ArrayList devices, Serializable opaqueObject, String name) throws HException {
        RemovableMediaDevice device = null;
        this.introLabel = introLabel;
        if (devices != null && devices.size() > 0) {
            Iterator i = devices.iterator();
            while (i.hasNext()) {
                device = (RemovableMediaDevice)i.next();
                if (device != null) continue;
                throw new HException("Device is null.");
            }
        } else {
            throw new HException("Device list is empty.");
        }
        this.devices = devices;
        this.opaqueObject = opaqueObject;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->RemovableMediaChoiceBean(" + devices + ", " + name + ")");
    }

    public ValueDescriptor[] getListBoxList() {
        Trace.trace(TRACE_MASKT, "<->getListBoxList() returning " + this.m_vdListBox);
        return this.m_vdListBox;
    }

    public void setListBox(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setListBox(" + s + ")");
        this.m_sListBox = s;
    }

    public String getListBox() {
        Trace.trace(TRACE_MASKT, "<->getListBox() returning " + this.m_sListBox);
        return this.m_sListBox;
    }

    public void setIntroLabel(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setIntrolLabel(" + s + ")");
        this.m_sIntroLabel = s;
    }

    public String getIntroLabel() {
        Trace.trace(TRACE_MASKT, "<->getIntrolLabel() returning " + this.m_sIntroLabel);
        return this.m_sIntroLabel;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        int index = 0;
        RemovableMediaDevice device = null;
        this.setIntroLabel(this.introLabel.toString());
        this.m_vdListBox = new ValueDescriptor[this.devices.size()];
        index = 0;
        Iterator i = this.devices.iterator();
        while (i.hasNext()) {
            device = (RemovableMediaDevice)i.next();
            this.m_vdListBox[index++] = CertMgtPanelUtils.createValueDescriptor("RemovableMediaChoiceListBox", device.getDisplayableDescription().toString());
        }
        this.m_sListBox = "";
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        String elementName = null;
        String actionCommand = null;
        UserTaskManager utm = null;
        String choice = null;
        RemovableMediaDevice currentDevice = null;
        Object deviceChosen = null;
        String internalDeviceName = null;
        Trace.trace(TRACE_MASKT, "->panelAction(" + event + ")");
        if (event != null) {
            Trace.trace(TRACE_MASKF, "Bean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
            elementName = event.getElementName();
            actionCommand = event.getActionCommand();
            utm = this.getUserTaskManager();
            if (actionCommand.equals("RemovableMediaChoiceOKButton")) {
                choice = this.getListBox();
                if (choice.length() > 0) {
                    Iterator i = this.devices.iterator();
                    while (i.hasNext()) {
                        currentDevice = (RemovableMediaDevice)i.next();
                        if (!choice.equals(currentDevice.getDisplayableDescription().toString())) continue;
                        internalDeviceName = currentDevice.getInternalName();
                        break;
                    }
                    if (internalDeviceName != null) {
                        CertMgtPanelUtils.sendTaskletRequest(actionCommand, internalDeviceName, this.opaqueObject, null, this);
                    } else if (utm != null) {
                        try {
                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0045"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0044"), MsgType.ERROR_MESSAGE);
                        }
                        catch (HException e) {
                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                        }
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "No choice made in panelAction(...).");
                    if (utm != null) {
                        try {
                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0012"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0048"), MsgType.ERROR_MESSAGE);
                        }
                        catch (HException e) {
                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                        }
                    }
                }
            } else if (elementName.equals("CancelButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...) : " + actionCommand);
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }
}

